/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StringUtil {
    public static final char[] slugChars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};

    public static boolean isSlugChar(char c) {
        int x = 0;
        while (x < slugChars.length) {
            if (c == slugChars[x]) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public static String uncamelify(String str) {
        StringBuilder buf = new StringBuilder();
        int x = 0;
        while (x < str.length()) {
            char c = str.charAt(x);
            if (c >= 'A' && c <= 'Z') {
                if (x > 0) {
                    buf.append('_');
                }
                buf.append(Character.toLowerCase(c));
            } else {
                buf.append(str.charAt(x));
            }
            ++x;
        }
        return buf.toString();
    }

    public static String camelify(String c) {
        String[] tokens = c.split("_");
        StringBuilder b = new StringBuilder();
        int x = 0;
        while (x < tokens.length) {
            char d = tokens[x].charAt(0);
            b.append(Character.toUpperCase(d));
            b.append(tokens[x].substring(1));
            ++x;
        }
        return b.toString();
    }

    public static String slugify(String s) {
        if (s == null) {
            return "empty";
        }
        s = s.trim();
        s = s.toLowerCase();
        s = s.replaceAll("[^a-z0-9 \\-\\_]", "");
        s = s.replaceAll(" +", "-");
        s = s.replaceAll("_", "-");
        s = s.replaceAll("-+", "-");
        s = s.replaceAll("^-", "");
        s = s.replaceAll("-+$", "");
        return s;
    }

    public static String inputStream2String(InputStream is) throws IOException {
        int len;
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((len = bis.read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        baos.close();
        bis.close();
        return baos.toString("UTF-8");
    }

    public static boolean isEmpty(String t) {
        return t == null || t.trim().length() == 0;
    }

    public static boolean notEmpty(String t) {
        return t != null && t.trim().length() > 0;
    }

    public static void write2file(File p, String data) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(p));
        bos.write(data.getBytes());
        bos.close();
    }

    public static String escapeJson(String str) {
        str = str.replaceAll("(['\"])", "\\\\$1");
        return str;
    }

    public static String escapeAttr(String str) {
        str = str.replaceAll("\"", "&quot;");
        str = str.replaceAll("'", "&#39;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        return str;
    }

    public static String escapeHtml(String text) {
        StringBuilder sb = new StringBuilder();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    public static Integer occurrences(String s, char c) {
        int count = 0;
        int x = 0;
        while (x < s.length()) {
            if (s.charAt(x) == c) {
                ++count;
            }
            ++x;
        }
        return count;
    }

    public static String join(String glue, Integer[] l) {
        StringBuffer buf = new StringBuffer();
        int x = 0;
        while (x < l.length) {
            if (x > 0) {
                buf.append(glue);
            }
            buf.append(l[x]);
            ++x;
        }
        return buf.toString();
    }

    public static String join(String glue, String[] l) {
        StringBuffer buf = new StringBuffer();
        int x = 0;
        while (x < l.length) {
            if (x > 0) {
                buf.append(glue);
            }
            buf.append(l[x]);
            ++x;
        }
        return buf.toString();
    }

    public static String join(String glue, List l) {
        StringBuffer buf = new StringBuffer();
        int x = 0;
        while (x < l.size()) {
            if (x > 0) {
                buf.append(glue);
            }
            if (l.get(x) == null) {
                buf.append("null");
            } else {
                buf.append(l.get(x).toString());
            }
            ++x;
        }
        return buf.toString();
    }

    public static List<String> split(String regexp, String line) {
        String[] toks;
        ArrayList<String> l = new ArrayList<String>();
        if (line == null) {
            return l;
        }
        String[] stringArray = toks = line.split(regexp);
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            if ((tok = tok.trim()).length() > 0) {
                l.add(tok);
            }
            ++n2;
        }
        return l;
    }

    public static List<String> splitUnique(String regexp, String line) {
        String[] toks;
        ArrayList<String> l = new ArrayList<String>();
        if (line == null) {
            return l;
        }
        String[] stringArray = toks = line.split(regexp);
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            if ((tok = tok.trim()).length() > 0 && l.indexOf(tok) == -1) {
                l.add(tok);
            }
            ++n2;
        }
        return l;
    }

    public static String trim(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    public static String rtrim(String s, char c) {
        int x = s.length() - 1;
        while (x >= 0) {
            if (s.charAt(s.length() - 1) != c) break;
            s = s.substring(0, s.length() - 1);
            --x;
        }
        return s;
    }

    public static String ltrim(String s, char c) {
        do {
            if (s.length() <= 0 || s.charAt(0) != c) continue;
            s = s.substring(1, s.length());
        } while (s.length() > 0 && s.charAt(0) == c);
        return s;
    }

    public static String doubleRounded(Double d) {
        String f = String.format("%.02f", d);
        f = f.replace(',', '.');
        return f;
    }

    public static String md5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            byte[] digest = md.digest();
            return String.format("%032x", new BigInteger(1, digest));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String applyVars(String val, Map<String, String> vars) {
        for (String k : vars.keySet()) {
            val = val.replaceAll("\\[\\[" + k + "\\]\\]", vars.get(k));
        }
        return val;
    }

    public static String normalizeUrl(String url) {
        int s = url.lastIndexOf("://");
        String l = url.substring(0, s);
        String r = url.substring(s + 3);
        r = r.replaceAll("\\/+", "/");
        return l + "://" + r;
    }

    public static void main(String[] args) {
        try {
            List<String> list = StringUtil.splitUnique(",", "blabla,,, jojo, blabla, lets ff gooo,1,2,3,4");
            for (String i : list) {
                System.out.println("i: " + i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

